/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWCalendarControlDialog;
import filenet.vw.toolkit.utils.uicontrols.calendar.VWDateTimeFormat;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class VWSIMDailyPropertiesPanel
extends JPanel
implements ActionListener,
DocumentListener {
    protected JTextField m_timeTextField = null;
    protected JButton m_timeButton = null;
    protected VWNumericTextField m_durationTextField = null;
    protected JComboBox m_durationComboBox = null;
    protected VWNumericTextField m_startFromTextField = null;
    protected VWNumericTextField m_repeatTextField = null;
    protected VWNumericTextField m_endAfterTextField = null;
    protected VWSIMPropertyData m_propertyData = null;
    protected VWScenarioShiftDefinition m_shiftDef = null;

    public void init(VWSIMPropertyData propertyData) {
        try {
            this.m_propertyData = propertyData;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(0, 5, 5, 5);
            JPanel childPanel = this.getMainControlPanel();
            if (childPanel != null) {
                this.add((Component)childPanel, gbCons);
            }
            ++gbCons.gridy;
            childPanel = this.getAdvancedControlPanel();
            if (childPanel != null) {
                this.add((Component)childPanel, gbCons);
            }
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            this.add((Component)new JLabel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setShiftDefinition(VWScenarioShiftDefinition shiftDef) {
        if (shiftDef != null) {
            this.m_shiftDef = shiftDef;
            this.reinitialize();
        }
    }

    public void setEnabled(boolean bEnable) {
        super.setEnabled(bEnable);
        this.m_timeTextField.setEnabled(bEnable);
        this.m_timeButton.setEnabled(bEnable);
        this.m_durationTextField.setEnabled(bEnable);
        this.m_durationComboBox.setEnabled(bEnable);
        this.m_startFromTextField.setEnabled(bEnable);
        this.m_repeatTextField.setEnabled(bEnable);
        this.m_endAfterTextField.setEnabled(bEnable);
    }

    public void releaseReferences() {
        this.m_timeTextField = null;
        this.m_timeButton = null;
        this.m_durationTextField = null;
        this.m_durationComboBox = null;
        this.m_startFromTextField = null;
        this.m_repeatTextField = null;
        this.m_endAfterTextField = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_timeButton) {
            this.performTimeButtonAction();
        } else if (src == this.m_durationComboBox) {
            this.performDurationComboBoxAction();
        }
    }

    public void changedUpdate(DocumentEvent event) {
        Document doc = event.getDocument();
        if (doc == this.m_timeTextField.getDocument()) {
            this.updateTimeTextField();
        } else if (doc == this.m_durationTextField.getDocument()) {
            this.updateDurationTextField();
        } else if (doc == this.m_startFromTextField.getDocument()) {
            this.updateStartFromTextField();
        } else if (doc == this.m_repeatTextField.getDocument()) {
            this.updateRepeatTextField();
        } else if (doc == this.m_endAfterTextField.getDocument()) {
            this.updateEndAfterTextField();
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    protected JPanel getMainControlPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.initDateTimeControls(mainPanel, gbCons);
            this.initDurationControls(mainPanel, gbCons);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void initDateTimeControls(JPanel childPanel, GridBagConstraints gbCons) {
        try {
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            JLabel timeLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_time));
            childPanel.add((Component)timeLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.3;
            this.m_timeTextField = new JTextField();
            this.m_timeTextField.getDocument().addDocumentListener(this);
            this.m_timeTextField.setEditable(false);
            childPanel.add((Component)this.m_timeTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.7;
            this.m_timeButton = VWSIMImageLoader.createIconButton("calendar.gif", VWSIMResource.s_calendar);
            this.m_timeButton.addActionListener(this);
            childPanel.add((Component)this.m_timeButton, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void initDurationControls(JPanel childPanel, GridBagConstraints gbCons) {
        try {
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            JLabel durationLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_duration));
            childPanel.add((Component)durationLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.3;
            this.m_durationTextField = new VWNumericTextField(6, 0, false);
            this.m_durationTextField.getDocument().addDocumentListener(this);
            childPanel.add((Component)this.m_durationTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.7;
            this.m_durationComboBox = new JComboBox();
            this.m_durationComboBox.addItem(VWSIMResource.s_seconds);
            this.m_durationComboBox.addItem(VWSIMResource.s_minutes);
            this.m_durationComboBox.addItem(VWSIMResource.s_hours);
            this.m_durationComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_durationComboBox.addActionListener(this);
            childPanel.add((Component)this.m_durationComboBox, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getAdvancedControlPanel() {
        try {
            VWToolbarBorder advancedToolbarBorder = new VWToolbarBorder(VWSIMResource.s_advancedSettings);
            JPanel advancedPanel = advancedToolbarBorder.getClientPanel();
            advancedPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.initStartFromControls(advancedPanel, gbCons, VWSIMResource.s_daysAfterSimulationStarts);
            this.initRepeatEveryControls(advancedPanel, gbCons, VWSIMResource.s_days);
            this.initEndAfterControls(advancedPanel, gbCons);
            return advancedToolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void initStartFromControls(JPanel childPanel, GridBagConstraints gbCons, String label2Text) {
        try {
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            JLabel startFromLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_startFrom));
            childPanel.add((Component)startFromLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.3;
            this.m_startFromTextField = new VWNumericTextField(6, 0, false);
            this.m_startFromTextField.getDocument().addDocumentListener(this);
            childPanel.add((Component)this.m_startFromTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.7;
            JLabel startFromLabel2 = new JLabel(label2Text);
            childPanel.add((Component)startFromLabel2, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void initRepeatEveryControls(JPanel childPanel, GridBagConstraints gbCons, String label2Text) {
        try {
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            JLabel repeatLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_repeatEvery));
            childPanel.add((Component)repeatLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.3;
            this.m_repeatTextField = new VWNumericTextField(6, 0, false);
            this.m_repeatTextField.getDocument().addDocumentListener(this);
            childPanel.add((Component)this.m_repeatTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.7;
            JLabel repeatLabel2 = new JLabel(label2Text);
            childPanel.add((Component)repeatLabel2, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void initEndAfterControls(JPanel childPanel, GridBagConstraints gbCons) {
        try {
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            JLabel endAfterLabel = new JLabel(VWSIMResource.s_colon.toString(VWSIMResource.s_endAfter));
            childPanel.add((Component)endAfterLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.3;
            this.m_endAfterTextField = new VWNumericTextField(6, 0, false);
            childPanel.add((Component)this.m_endAfterTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.7;
            JLabel endAfterLabel2 = new JLabel(VWSIMResource.s_optionalIterations);
            childPanel.add((Component)endAfterLabel2, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void updateTimeTextField() {
        try {
            String timeString = this.m_timeTextField.getText();
            if (timeString != null && timeString.length() > 0) {
                this.m_shiftDef.setStartTime(VWDateTimeFormat.convertTimeStringToSeconds(timeString));
                this.m_propertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performTimeButtonAction() {
        Date initDateTime = new Date(this.m_shiftDef.getStartTime());
        String initDate = VWDateTimeFormat.getDateString(initDateTime);
        String initTime = this.m_timeTextField.getText();
        VWCalendarControlDialog calendarDlg = new VWCalendarControlDialog(this.m_propertyData.getParentFrame(), 101, initDate + " " + initTime);
        calendarDlg.setVisible(true);
        int status = calendarDlg.getCloseStatus();
        if (status == 1) {
            Date date = calendarDlg.getDate();
            String timeString = VWDateTimeFormat.getTimeString(date);
            this.m_timeTextField.setText(timeString);
        }
    }

    protected void updateDurationTextField() {
        try {
            String durationString = this.m_durationTextField.getText();
            this.m_shiftDef.getDuration().setDuration(durationString);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void performDurationComboBoxAction() {
        try {
            int durationUnit = 1;
            String durationUnitString = (String)this.m_durationComboBox.getSelectedItem();
            if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_seconds) == 0) {
                durationUnit = 1;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_minutes) == 0) {
                durationUnit = 2;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_hours) == 0) {
                durationUnit = 3;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_days) == 0) {
                durationUnit = 4;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_weeks) == 0) {
                durationUnit = 5;
            } else if (VWStringUtils.compare(durationUnitString, VWSIMResource.s_months) == 0) {
                durationUnit = 6;
            }
            this.m_shiftDef.getDuration().setUnits(durationUnit);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void updateStartFromTextField() {
        try {
            String startFrom = this.m_startFromTextField.getText();
            Integer start = new Integer(startFrom);
            this.m_shiftDef.setStartInterval(start);
            this.m_propertyData.setDirty();
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void updateEndAfterTextField() {
        try {
            String occurence = this.m_endAfterTextField.getText();
            Integer occurenceInt = new Integer(occurence);
            if (occurenceInt != null) {
                this.m_shiftDef.setOccurrencesInterval(occurenceInt);
                this.m_propertyData.setDirty();
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void updateRepeatTextField() {
        try {
            String repeatString = this.m_repeatTextField.getText();
            Integer repeat = new Integer(repeatString);
            if (repeat != null) {
                int repeatValue = repeat;
                this.m_shiftDef.setEveryInterval(repeatValue);
                this.m_propertyData.setDirty();
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        try {
            this.m_timeTextField.getDocument().removeDocumentListener(this);
            this.m_timeTextField.setText(VWDateTimeFormat.convertSecondsToTimeString(this.m_shiftDef.getStartTime()));
            this.m_timeTextField.getDocument().addDocumentListener(this);
            VWScenarioTimeDuration duration = this.m_shiftDef.getDuration();
            this.m_durationComboBox.removeActionListener(this);
            switch (duration.getUnits()) {
                case 1: {
                    this.m_durationComboBox.setSelectedItem(VWSIMResource.s_seconds);
                    break;
                }
                case 2: {
                    this.m_durationComboBox.setSelectedItem(VWSIMResource.s_minutes);
                    break;
                }
                case 3: {
                    this.m_durationComboBox.setSelectedItem(VWSIMResource.s_hours);
                    break;
                }
                case 4: {
                    this.m_durationComboBox.setSelectedItem(VWSIMResource.s_days);
                    break;
                }
                case 5: {
                    this.m_durationComboBox.setSelectedItem(VWSIMResource.s_weeks);
                    break;
                }
                case 6: {
                    this.m_durationComboBox.setSelectedItem(VWSIMResource.s_months);
                }
            }
            this.m_durationComboBox.addActionListener(this);
            this.m_durationTextField.getDocument().removeDocumentListener(this);
            this.m_durationTextField.setText(duration.getDuration());
            this.m_durationTextField.getDocument().addDocumentListener(this);
            this.m_startFromTextField.getDocument().removeDocumentListener(this);
            this.m_startFromTextField.setText(this.m_shiftDef.getStartInterval() + "");
            this.m_startFromTextField.getDocument().addDocumentListener(this);
            this.m_repeatTextField.getDocument().removeDocumentListener(this);
            this.m_repeatTextField.setText("" + this.m_shiftDef.getEveryInterval());
            this.m_repeatTextField.getDocument().addDocumentListener(this);
            this.m_endAfterTextField.getDocument().removeDocumentListener(this);
            Integer occurrence = null;
            try {
                occurrence = this.m_shiftDef.getOccurrencesInterval();
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            String occurrenceString = "";
            if (occurrence != null) {
                occurrenceString = occurrence.toString();
            }
            this.m_endAfterTextField.setText(occurrenceString);
            this.m_endAfterTextField.getDocument().addDocumentListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

